package cn.com.duiba.developer.center.api.domain.dto.strategy;

import cn.com.duiba.developer.center.api.domain.enums.StrategyDynamicDataTypeEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * 动态类型数据，支持级联筛选
 *
 * @Author: xuwei
 * @Date: 2020/05/27
 */
public class StrategyDynamicDataDto implements Serializable {

    private static final long serialVersionUID = 6412928122210221593L;

    /**
     * 默认上级
     */
    public static final Long PARENT_DEFAULT = 0L;

    /**
     * ID
     */
    private Long id;

    /**
     * 上级ID
     */
    private Long parentId;

    /**
     * 数据类型 10:行业 1000:客户 1001:经营指标 11:玩法类型 12:玩法组件 13:投放渠道 14:面向用户 15:预期目标 16:经验类型 17:经验标签 18:数据模板 19:数据模板字段
     * @see {@link StrategyDynamicDataTypeEnum}
     */
    private Integer type;

    /**
     * 名称
     */
    private String name;

    /**
     * 数据
     */
    private String content;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}