package cn.com.duiba.developer.center.api.domain.dto.survey;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class SurveySubmitDto implements Serializable {
    private static final long serialVersionUID = -7674862679373573402L;
    /**
     * 问券Id
     */
    @NotNull
    private Long surveyId;
    /**
     * 问券版本
     */
    @NotNull
    private Integer version;

    private Long appId;
    /**
     * 开发者(消费)id
     */
    @NotNull
    private Long consumerId;

    /**
     * 开始填写时间
     */
    private Date startAt;
    /**
     * 结束填写时间
     */
    private Date endAt;

    @NotNull
    private List<AnswerDto> answers;

    private Long recordId;

    /**
     * 不同app定制存储的信息，必须为json
     */
    private String customInfo;

    /**
     * 应用场景
     */
    private Integer channel;

    public Long getSurveyId() {
        return surveyId;
    }

    public void setSurveyId(Long surveyId) {
        this.surveyId = surveyId;
    }

    public Integer getVersion() {
        return version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Date getStartAt() {
        return startAt;
    }

    public void setStartAt(Date startAt) {
        this.startAt = startAt;
    }

    public Date getEndAt() {
        return endAt;
    }

    public void setEndAt(Date endAt) {
        this.endAt = endAt;
    }

    public List<AnswerDto> getAnswers() {
        return answers;
    }

    public void setAnswers(List<AnswerDto> answers) {
        this.answers = answers;
    }

    public Long getRecordId() {
        return recordId;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }

    public String getCustomInfo() {
        return customInfo;
    }

    public void setCustomInfo(String customInfo) {
        this.customInfo = customInfo;
    }

    public Integer getChannel() {
        return channel;
    }

    public void setChannel(Integer channel) {
        this.channel = channel;
    }
}
