package cn.com.duiba.developer.center.api.domain.enums;

import java.util.Objects;

public enum ExpChannelTypeEnum {
    EVERYDAY_LOGIN(1,"每日登录"),
    EXCHANGE(2,"兑换"),
    JOIN_ACTIVITY(3,"参与活动")
    ;

    private Integer code;

    private String desc;

    ExpChannelTypeEnum(Integer code,String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ExpChannelTypeEnum getEnumByCode(Integer code){
        if(null==code){
            return null;
        }
        for (ExpChannelTypeEnum enumVal : ExpChannelTypeEnum.values()) {
            if (Objects.equals(code,enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
