package cn.com.duiba.developer.center.api.domain.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * 商品区数据来源类型
 * Created by xiaoxuda on 2017/5/17.
 */
public enum ItemListTypeEnum {
    ALL(0,"所有已上架商品"),
    CLASSIFY(1,"自定义分类");

    private static Map<Integer,ItemListTypeEnum> typeEnumMap = new HashMap<>();
    static{
        for(ItemListTypeEnum type : ItemListTypeEnum.values()){
            typeEnumMap.put(type.getCode(),type);
        }
    }
    public static ItemListTypeEnum getByCode(Integer code){
        return typeEnumMap.get(code);
    }

    private Integer code;
    private String desc;

    ItemListTypeEnum(Integer code,String desc){
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
