/**
 * Project Name:developer-center-api File Name:SubPageTargetEnum.java Package
 * Name:cn.com.duiba.developer.center.api.domain.enums Date:2016年8月19日下午4:29:49 Copyright (c) 2016, duiba.com.cn All
 * Rights Reserved.
 */

package cn.com.duiba.developer.center.api.domain.enums;


import java.util.Objects;

/**
订购标签
 */
public enum PurchaseTagEnum {
    VERSION_SERVICE_TAG(1L, "版本服务套餐"),
    FEARURE_TAG(2L, "功能增购"),
    CUSTOM_TAG(3L, "定制增购"),
    EQUITY_TAG(4L, "权益增购"),
    OPERATE_TAG(5L, "代运营服务"),
    ACTIVITY_TAG(6L, "活动增购"),
    UI_TAG(7L, "视觉服务"),
    CUSTOM_INTERFACE(8L, "定制接口"),
    ;

    /** 代码 */
    private Long code;

    /** 描述 */
    private String desc;

    private PurchaseTagEnum(Long code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    public static PurchaseTagEnum getByCode(Long code) {
        for (PurchaseTagEnum enumVal : PurchaseTagEnum.values()) {
            if (Objects.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    public Long getCode() {
        return code;
    }

    public void setCode(Long code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
