/**
 * Project Name:developer-center-api
 * File Name:AppPushStatusEnum.java
 * Package Name:cn.com.duiba.developer.center.api.domain.enums
 * Date:2016年11月2日下午9:51:11
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.developer.center.api.domain.enums.authority;

import java.util.Objects;

/**
 * 业务活动权限关联枚举<br/>
 */
public enum RightBusinessTagEnum {

    //基础服务下的业务标签
    MALL_FIT(1,"商场装修"),
    ITEM_MANAGER(2,"商品管理"),
    ORDER_MANAGER(3,"订单管理"),
    PROPERTY_MANAGER(4,"资产管理"),
    ITEM_RIGHT(5,"商品权益"),

    //组件服务下
//    UNIT_MANAGER(6,"组件服务"),

    //营销落地页服务下
    MALl_ACTIVITY(7,"活动列表"),

    //补给站活动
    ACTIVITY_TOOL(9,"活动工具"),
    ACTIVITY_SIGN(10,"契约签到"),

    //补给站活动
    SALE_TOOL(11,"营销工具"),
    RIGHT_FIRST(12,"权益特权"),
    PLUS_RIGHT(13,"增值功能"),

    /**
     * 活动平台下的类型
     */
    PULL_NEW_ACTIVITY(14,"拉新活动"),
    PROMOTE_ACTIVITY(15,"促活活动"),
    TRANSFORM_ACTIVITY(16,"转化活动"),
    FISSION_ACTIVITY(17,"裂变活动"),
    TOOL_ACTIVITY(18,"工具活动"),

    ;

    private Integer code;
    private String desc;

    RightBusinessTagEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static RightBusinessTagEnum getByDesc(String value){
        if(value == null){
            return null;
        }
        for(RightBusinessTagEnum rightBusinessTagEnum:RightBusinessTagEnum.values()){
            if(Objects.equals(rightBusinessTagEnum.getCode(),value) ){
                return rightBusinessTagEnum;
            }
        }
        return null;
    }

    public static RightBusinessTagEnum getByCode(Integer code){
        if(code == null){
            return null;
        }
        for(RightBusinessTagEnum rightBusinessTagEnum:RightBusinessTagEnum.values()){
            if(Objects.equals(rightBusinessTagEnum.getCode(),code) ){
                return rightBusinessTagEnum;
            }
        }
        return null;
    }
}

