/**
 * Project Name:developer-center-api
 * File Name:AppPushStatusEnum.java
 * Package Name:cn.com.duiba.developer.center.api.domain.enums
 * Date:2016年11月2日下午9:51:11
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.developer.center.api.domain.enums.authority;

import java.util.Objects;

/**
 * 套餐权限枚举<br/>
 */
public enum RightOperationTypeEnum {

    //常用权限
    SAVE(1,"保存"),
    EDIT(2,"编辑"),
    NEW(3,"新建"),
    SELECT(4,"查询"),
    DELETE(5,"删除"),
    ALL(6,"所有权限"),

    PUBLISH(7,"发布"),
    UPLOADING(8,"上传"),
    UPLOADING_ITEM(9,"添加商品"),
    BATCH_PUTWAY(10,"批量上架"),
    EXPORT(11,"导出"),
    AGREE(12,"同意"),
    REFUSE(13,"拒绝"),
    CANCEL_ORDER(14,"取消订单"),
    RECHARGE(15,"充值"),
    FINISH(16,"完成"),
    PUTWAY(17,"上架"),
    DELIVER(18,"发货"),

    ;

    private Integer code;
    private String desc;

    RightOperationTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }


    public static RightOperationTypeEnum getByDesc(String value){
        if(value == null){
            return null;
        }
        for(RightOperationTypeEnum rightOperationTypeEnum:RightOperationTypeEnum.values()){
            if(Objects.equals(rightOperationTypeEnum.getDesc(),value) ){
                return rightOperationTypeEnum;
            }
        }
        return null;
    }
}

