package cn.com.duiba.developer.center.api.domain.enums.authority;

import java.util.HashMap;
import java.util.Map;

/**
 * @author liukai
 * @Description:  版本销售类型
 * @date 2019/8/144:44 PM
 */
public enum VersionSaleTypeEnum {

    VERSION(1, "版本"),
    RETAIL(2, "零售包")
    ;

    private static final Map<Integer, VersionSaleTypeEnum> enumMap = new HashMap<>();
    static{
        for(VersionSaleTypeEnum versionSaleTypeEnum : values()){
            enumMap.put(versionSaleTypeEnum.getCode(), versionSaleTypeEnum);
        }
    }

    public static VersionSaleTypeEnum getByCode(Integer code){
        VersionSaleTypeEnum versionSaleTypeEnum = enumMap.get(code);
        if(versionSaleTypeEnum == null){
            return null;
        }
        return versionSaleTypeEnum;
    }

    private Integer code;
    private String desc;


    VersionSaleTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }


    public String getDesc() {
        return desc;
    }
}
