package cn.com.duiba.developer.center.api.domain.enums.crm;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by 刘凯 on 2020/06/12.
 */
public enum ClueApplyStageEnum {

    WAIT_ACTIVITY(1,"待激活"),
    ONLINE(2,"上线中"),
    RENEW(3,"续费期"),
    GONE(4,"流失"),
    UNPAID(5, "未付费"),
    ;


    private static final Map<Integer, ClueApplyStageEnum> enumMap = new HashMap<>();
    static{
        for(ClueApplyStageEnum clueApplyStageEnum : values()){
            enumMap.put(clueApplyStageEnum.getCode(), clueApplyStageEnum);
        }
    }

    public static ClueApplyStageEnum getByCode(Integer code){
        ClueApplyStageEnum clueApplyStageEnum = enumMap.get(code);
        if(clueApplyStageEnum == null){
            return null;
        }
        return clueApplyStageEnum;
    }


    private Integer code;
    private String desc;

    ClueApplyStageEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
