package cn.com.duiba.developer.center.api.domain.enums.forum;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by zyj on 2018/5/18.
 */
public enum AnnouncementStatusEnum {
    /**
     * 公告上下篇类型
     */
    EXPAND_RELEASE(0,"发布"),
    EXPAND_DRAFT(1,"草稿");

    private static final Map<Integer, AnnouncementStatusEnum> ENUM_MAP = new HashMap<>();
    static{
        for(AnnouncementStatusEnum statusEnum : values()){
            ENUM_MAP.put(statusEnum.getValue(), statusEnum);
        }
    }

    public static AnnouncementStatusEnum getByCode(Integer code){
        AnnouncementStatusEnum statusEnum = ENUM_MAP.get(code);
        if(statusEnum == null){
            throw new DeveloperCenterException("不支持的状态");
        }
        return statusEnum;
    }

    private int   value;
    private String desc;

    AnnouncementStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}
