package cn.com.duiba.developer.center.api.domain.enums.saas;

import cn.com.duiba.developer.center.api.DeveloperCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Administrator on 2018/4/26.
 */
public enum AgentPaymentMethodEnum {
    /**
     * 支付方式
     * paymentMethod
     */
    ALIPAY(1,"支付宝"),
    BANK_CARD(2,"银行卡");

    private static final Map<Integer, AgentPaymentMethodEnum> ENUM_MAP = new HashMap<>();
    static{
        for(AgentPaymentMethodEnum paymentMethodEnum : values()){
            ENUM_MAP.put(paymentMethodEnum.getValue(), paymentMethodEnum);
        }
    }

    public static AgentPaymentMethodEnum getByCode(Integer code){
        AgentPaymentMethodEnum paymentMethodEnum = ENUM_MAP.get(code);
        if(paymentMethodEnum == null){
            throw new DeveloperCenterException("不支持的支付类型");
        }
        return paymentMethodEnum;
    }

    private int    value;
    private String desc;

    AgentPaymentMethodEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

}
