package cn.com.duiba.developer.center.api.domain.enums.saas.redpacketsmanagetool;

/**
 * 按位，从低到高，每个bit对应一种，1,2,4,8,...存储
 * Created by HePeng on 2018/11/5 10:14.
 */
public enum GainTimesTypeEnum {
    VISIT_MALL_DAYS(1, "连续访问积分商城多少天"),
    FIXED_TIMES_MONTHLY(2, "每月固定多少次"),
    ;
    private int code;
    private String desc;

    GainTimesTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static GainTimesTypeEnum getByCode(Integer code) {
        if(code == null) {
            return null;
        }
        for (GainTimesTypeEnum enumVal : GainTimesTypeEnum.values()) {
            if (code == enumVal.getCode()) {
                return enumVal;
            }
        }
        return null;
    }

    public static boolean visitMallDaysFlag(Integer code) {
        return code != null && (code & VISIT_MALL_DAYS.getCode()) > 0;
    }

    public static boolean fixedTimesMonthlyFlag(Integer code) {
        return code != null && (code & FIXED_TIMES_MONTHLY.getCode()) > 0;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
