package cn.com.duiba.developer.center.api.domain.enums.saas.redpacketsmanagetool;

/**
 * Created by HePeng on 2018/10/29 11:29.
 */
public enum StatusEnum {
    STATUS_CLOSE(0, "关闭"),
    STATUS_OPEN(1, "开启"),
    ;

    private int code;
    private String desc;

    StatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static StatusEnum getByCode(Integer code) {
        if(code == null) {
            return null;
        }
        for (StatusEnum enumVal : StatusEnum.values()) {
            if (code == enumVal.getCode()) {
                return enumVal;
            }
        }
        return null;
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
