package cn.com.duiba.developer.center.api.domain.enums.survey;

import org.apache.commons.lang.StringUtils;

public enum OptionTypeEnum {
    /**
     * 答题时，只保存选项Id
     */
    NORMAL("普通"),
    /**
     * 答题时，除了选项Id，还要保存文本
     */
    OTHER("其他"),
    ;


    private final String msg;

    OptionTypeEnum(String msg) {
        this.msg = msg;
    }

    public String getMsg() {
        return msg;
    }

    @Override
    public String toString() {
        return this.name().toLowerCase();
    }

    public static OptionTypeEnum getByType(String type) {
        for (OptionTypeEnum value : OptionTypeEnum.values()) {
            if (StringUtils.equalsIgnoreCase(value.toString(), type)) {
                return value;
            }
        }
        // 识别不出，就当普通处理
        return OptionTypeEnum.NORMAL;
    }
}
