package cn.com.duiba.developer.center.api.domain.enums.visualeditor;

import org.apache.commons.lang.ObjectUtils;

/**
 * 通用组件枚举
 *
 * @Author chenxiangge
 * @Date 2019/7/1
 */
public enum CommTemplateUnitTypeEnum {
    BOTTOM_BAR(0, "底部操作栏"),
    ;

    private Integer type;
    private String desc;

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    CommTemplateUnitTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static CommTemplateUnitTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        for (CommTemplateUnitTypeEnum unitTypeEnum : CommTemplateUnitTypeEnum.values()) {
            if (ObjectUtils.equals(type, unitTypeEnum.getType())) {
                return unitTypeEnum;
            }
        }
        return null;
    }
}
