package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.AppSlotReleationDto;
import cn.com.duiba.developer.center.api.domain.enums.AppSlotChannelTypeEnum;
import cn.com.duiba.developer.center.api.domain.paramquery.AppSlotReleationQueryParams;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;

/**
 * Created by qianjue on 2018/4/10.
 */
@AdvancedFeignClient
public interface RemoteAppSlotReleationService {

	/**
	 * 分页查询接口
	 * @param params
	 * @return
	 */
	PaginationVO<AppSlotReleationDto> queryPageListByParam(AppSlotReleationQueryParams params);

	/**
	 * 根据appId和渠道类型查询渠道信息
	 * @param appId
	 * @param channelTypeEnum
	 * @return
	 */
	AppSlotReleationDto  findReleationByAppIdAndChannelType(Long appId,AppSlotChannelTypeEnum channelTypeEnum);

	/**
	 * 新增插入渠道关系
	 * @param dto
	 * @return
	 */
	AppSlotReleationDto  saveAppSlotReleation(AppSlotReleationDto dto) throws BizException;

	/**
	 * 根据appId和广告位Id查询相关信息
	 * @param appId
	 * @param slotId
	 * @return
	 */
	AppSlotReleationDto findReleationBySlotId(Long appId,Long slotId);
}
