package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.CenterConfigDto;
import cn.com.duiba.developer.center.api.domain.enums.CenterConfigEnum;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * Created by liuyao on 2016/9/28.
 */
@AdvancedFeignClient
public interface RemoteCenterConfigService {
    /**
     * 获取配置
     * @param type
     * @return
     * @deprecated
     */
    @Deprecated
    DubboResult<CenterConfigDto> findCenterConfig(CenterConfigEnum type);

    CenterConfigDto findCenterConfigNew(CenterConfigEnum type);

    /**
     * 按类型和app获得配置
     * @param type
     * @param appId
     * @return
     */
    CenterConfigDto findByTypeAndAppId(CenterConfigEnum type,Long appId);

    /**
     * 根据id查找
     * @param id
     * @return
     */
    DubboResult<CenterConfigDto> find(Long id);

    /**
     * 新插入
     * @param centerConfigDto
     */
    DubboResult<Long> insert(CenterConfigDto centerConfigDto);

    /**
     * 更新配置
     * @param centerConfigDto
     * @return
     */
    DubboResult<Integer> update(CenterConfigDto centerConfigDto);

    DubboResult<CenterConfigDto> findByType(CenterConfigEnum type);

    /**
     * 获取微信的域名配置
     * @param type
     * @return
     */
    DubboResult<CenterConfigDto> findByTypeInWechat(CenterConfigEnum type,Long appId);

    List<CenterConfigDto> findByTypeList(List<String> typeList);

}
