package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.DeveloperSubDto;
import cn.com.duiba.developer.center.api.domain.paramquery.CreateDeveloperSubParams;

import java.util.List;

/**
 * Created by sunyan on 2017/12/19.
 */
@AdvancedFeignClient
public interface RemoteDeveloperSubService {
    /**
     * 创建子账户
     * @param createDeveloperSubParams
     */
    Long createDeveloperSub(CreateDeveloperSubParams createDeveloperSubParams) throws BizException;

    /**
     * 修改子账户信息
     * @param developerSubDto
     * @return
     */
    int updateDeveloperSubInfo(DeveloperSubDto developerSubDto);

    /**
     * 修改子账户密码
     * @param id
     * @param loginPassword
     * @return
     */
    int updatePassword(Long id, String loginPassword);

    /**
     * 删除子账户
     * @param id
     * @return
     */
    int delDeveloperSub(Long id);

    /**
     * 根据developerId查询子账户
     */
    List<DeveloperSubDto> findByDeveloperId(Long developerId);

    /**
     * 根据developerId查询未删除的子账户
     */
    List<DeveloperSubDto> findNotDelByDeveloperId(Long developerId);

    /**
     * 根据loginName查询子账户
     */
    DeveloperSubDto findByLoginName(String loginName);

    /**
     * 根据did查询子账户
     */
    DeveloperSubDto findById(Long id);
}
