package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.DlpIncomeDetaiPageDto;
import cn.com.duiba.developer.center.api.domain.dto.DlpIncomeDetailDto;
import cn.com.duiba.developer.center.api.domain.vo.DlpIncomeDetailTotalVO;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * Created by ZQian on 2016/8/9.
 */
@AdvancedFeignClient
public interface RemoteDlpIncomeDetailService {
    /**
     * 获取收入详情分页列表
     * @param params
     * @return
     */
    public DubboResult<List<DlpIncomeDetailDto>> findIncomeDetailList(Map<String, Object> params);

    /**
     * 获取收入详情分页总数
     * @param params
     * @return
     */
    public DubboResult<Long> findIncomeDetailCount(Map<String, Object> params);


    /**
     * 列表查询
     * @param dto
     * @return
     */
    List<DlpIncomeDetailDto> findIncomeDetailListNew(DlpIncomeDetaiPageDto dto);

    /**
     * 查询总数
     * @param dto
     * @return
     */
    DlpIncomeDetailTotalVO countIncomeDetail(DlpIncomeDetaiPageDto dto);
}
