package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.SubjectRecordDto;

import java.util.Date;
import java.util.List;

/**
 * @Author: lufeng
 * @Description:
 * @Date: Created in 2019/8/20
 */
@AdvancedFeignClient
public interface RemoteSubjectRecordService {

    /**
     * 通过开发者id和时间 获取主体
     * @param developerId
     * @param data
     * @return
     */
    String getSubjectByDevelopIdAndData(Long developerId, Date data);

    /**
     * 通过应用id和时间 获取主体
     * @param developerId
     * @param data
     * @return
     */
    String getSubjectByAppIdAndDate(Long developerId, Date data);

    /**
     * 通过开发者id获取主体变更记录
     * @param developerId
     * @return
     */
    List<SubjectRecordDto> listSubjectDetailByDeveloperId(Long developerId);

    /**
     * 通过开发者id批量获取主体变更记录
     * @param developerIds
     * @return
     */
    List<SubjectRecordDto> listSubjectDetailByDeveloperIds(List<Long> developerIds);
}
