/**
 * Project Name:developer-center-api
 * File Name:RemoteTagService.java
 * Package Name:cn.com.duiba.developer.center.api.remoteservice
 * Date:2016年8月16日上午9:55:22
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.developer.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.AppTagDto;
import cn.com.duiba.developer.center.api.domain.dto.AppTagsMaskingDto;
import cn.com.duiba.developer.center.api.domain.dto.TagDto;
import cn.com.duiba.developer.center.api.domain.paramquery.TagQueryParam;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * ClassName:RemoteTagService <br/>
 * 商品标签dubbo服务 <br/>
 * Date:     2016年8月16日 上午9:55:22 <br/>
 * @author   zhanglihui
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@AdvancedFeignClient
public interface RemoteTagService {

    /**
     * 
     * 根据appId获取推荐商品标签列表
     *
     * @author zhanglihui
     * @param appId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<AppTagDto>> getRecommendedTags(Long appId);
    
    /**
     * 设置自动推荐商品标签
     *
     * @author zhanglihui
     * @param appId         app主键
     * @param autoRecommend 是否开启自动推荐
     * @param tagids        标签列表
     * @return
     * @since JDK 1.6
     */
    DubboResult<Void> setShieldTags(Long appId, boolean autoRecommend, List<Long> tagids);

    DubboResult<List<AppTagsMaskingDto>> findAllByTagsIds(List<Long> tagsIds);

    DubboResult<List<Long>> findShieldTagsByAppId(final Long appId);

    /**
     * 查询所有标签
     *
     * @author zhanglihui
     * @return
     * @since JDK 1.6
     */
    List<TagDto> findAllTags();

    /**
     * 根据标签名获取标签
     * @param tagsName
     * @return
     */
    TagDto findTagByName(String tagsName);

    /**
     * 删除标签
     * @param id
     */
    int deleteById(Long id);

    /**
     * 新增标签
     * @param tagDto
     */
    int insert(TagDto tagDto);

    /**
     * 更新标签
     * @param tagDto
     */
    int update(TagDto tagDto);

    /**
     * 获取标签
     * @param id
     * @return
     */
    TagDto findById(Long id);

    /**
     * 根据查询请求获取标签
     * @param queryParam
     * @return
     */
    PaginationVO<TagDto> findPage(TagQueryParam queryParam);
}

