package cn.com.duiba.developer.center.api.remoteservice.floor;

import java.util.List;
import java.util.Map;
import java.util.Set;

import org.springframework.web.bind.annotation.RequestMapping;

import com.alibaba.fastjson.JSONArray;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.AppSubpageLayoutDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

/**
 * @ClassName: RemoteAppSubpageLayoutService
 * @Description: TODO
 * @author: fxr
 * @date: 2018/8/1 下午3:55
 * @version: V1.0.0
 */
@AdvancedFeignClient
public interface RemoteAppSubpageLayoutService {

    /**
     * 开发选择使用楼层皮肤
     *
     * @param appId
     * @param skinId
     * @return
     */
    DubboResult<Boolean> devSetSkin(Long appId, Long skinId);

    /**
     * 开发选择使用楼层皮肤
     *
     * @param appId
     * @param skinId
     * @param ignoreFloorIds 需要忽略的楼层Id,忽略的楼层将会出现在楼层待选区
     * @return
     */
    @RequestMapping("devSetSkinWithIgnoreFloorIds")
    DubboResult<Boolean> devSetSkin(Long appId, Long skinId, List<Long> ignoreFloorIds);

    /**
     * [{id:楼层Id,floorType:楼层类型,enable:是否展示}]
     *
     * @param appId
     * @param skinId
     * @param floorSortList
     * @return
     */
    DubboResult<Boolean> devReSetFloorList(Long appId, Long skinId, JSONArray floorSortList);

    /**
     * 隐藏指定的楼层,将对应楼层的enable变成false
     *
     * @param appId
     * @param skinId
     * @param floorIds
     * @return
     */
    DubboResult<Integer> closeFloors(Long appId, Long skinId, Set<Long> floorIds);

    /**
     * 根据appId和floorId更新楼层配置
     * 如果楼层配置不存在，则把配置信息写入到developDataShowJson中；如果楼层配置存在，则更新developDataShowJson中的配置信息
     *
     * @param appId       app主键
     * @param skinId      app主键
     * @param floorId     楼层ID
     * @param floorConfig 楼层配置，楼层配置，配置项key值参见相应枚举对象 （ActivityFloorConfKeyEnum，CouponFloorConfKeyEnum， SnapUpFloorConfKeyEnum ...）
     * @return
     */
    DubboResult<Integer> updateDevFloorConfigByAppId(Long appId, Long skinId, Long floorId,
        Map<String, Object> floorConfig);

    /**
     * 高并发调用接口
     *
     * @param appId
     * @return
     */
    DubboResult<AppSubpageLayoutDto> getSubpageAppLayout(Long appId, Long skinId);

    /**
     * 根据appid 和 皮肤id删除自定义配置记录
     *
     * @param appId
     * @return
     */
    DubboResult<Integer> delBySkinIdAndAppId(Long appId, Long skinId);

}
