package cn.com.duiba.developer.center.api.remoteservice.monitor;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.monitor.WechatDomainMonitorDTO;
import cn.com.duiba.developer.center.api.domain.paramquery.monitor.WechatDomainMonitorParam;

import java.util.List;

/**
 * @ClassName RemoteWechatDomainMonitorService
 * @Description 微信域名防封监控remote
 * @Author zhoujunquan@duiba.com.cn
 * @Date 2021/7/19 2:55 下午
 * @Version 1.0
 **/
@AdvancedFeignClient
public interface RemoteWechatDomainMonitorService {
    /**
     * insert
     *
     * @param param 微信域名防封监控请求参数
     * @return 主键
     * @throws BizException
     */
    Long insert(WechatDomainMonitorParam param) throws BizException;

    /**
     * update
     *
     * @param param 微信域名防封监控请求参数
     * @return 影响的行数
     * @throws BizException
     */
    int update(WechatDomainMonitorParam param) throws BizException;

    /**
     * 根据条件分页查询
     *
     * @param param 微信域名防封监控请求参数
     * @return 查询结果列表
     */
    List<WechatDomainMonitorDTO> findList(WechatDomainMonitorParam param);

    /**
     * 根据条件查询总数
     *
     * @param param 微信域名防封监控请求参数
     * @return 总数
     */
    Long countTotal(WechatDomainMonitorParam param);

    /**
     * 删除
     *
     * @param id 主键id
     * @return 删除的行数
     */
    int delete(Long id);
}