package cn.com.duiba.developer.center.api.remoteservice.statistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.statistics.CreditsDistributionDto;
import cn.com.duiba.developer.center.api.domain.dto.statistics.DailyCreditsDistributionDto;
import cn.com.duiba.developer.center.api.domain.dto.statistics.OdpsAppCreditsDistributionDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Date;
import java.util.List;

/**
 * OdpsAppCreditsDistributionService
 */
@AdvancedFeignClient
public interface RemoteOdpsAppCreditsDistributionService {
	/**
	 * 根据App和时间
	 * @param appId
	 * @param day
	 * @return
	 */
	public DubboResult<OdpsAppCreditsDistributionDto> findAppCreditsDistributionByAppIdAndDay(Long appId, String day);

	/**
	 * 根据App和时间获取积分描述
	 *
	 * @param appId
	 * @param day
	 * @return
	 */
	public DubboResult<List<CreditsDistributionDto>> getAppCreditsDistributionByAppIdAndDay(Long appId, Date day);

	/**
	 * 根据app和时间范围查询
	 *
	 * @param appId
	 * @param startDate
	 * @param endDate
	 * @return
	 */
	List<DailyCreditsDistributionDto> findCreditsDistributionByAppIdAndDateRange(Long appId, Date startDate, Date endDate);

}
