package cn.com.duiba.developer.center.api.utils;

/**
 * 用于管理使用Hbase的所有key前缀，避免业务key重复<br>
 * 用法：枚举_业务参数
 * <p/>
 *
 * @author zouwx
 * @date 2022/08/30
 */
public enum HbaseKeyFactory {

    /**
     * key
     */
    PURCHASE_USER_NOTICE("获取广告用户通知信息"),
    PURCHASE_NOTICE("获取广告最近更新时间"),
    ;

    /**
     * 开发者中心:developer-center
     */
    private static final String SPACE = "DC";

    private static final String SEPARATOR = "_";

    private String description;

    /**
     * 拼接key前置
     */
    @Override
    public String toString() {
        return SPACE + "_" + super.toString() + "_";
    }


    public String join(Object... args) {
        StringBuilder key = new StringBuilder(SPACE).append(SEPARATOR).append(super.toString());
        for (Object arg :
                args) {
            key.append(SEPARATOR).append(arg);
        }
        return key.toString();
    }

    /**
     * 生成唯一的Hbasekey
     *
     * @param obj 一般是id
     * @return
     */
    public String getKey(Object obj) {
        return new StringBuilder(SPACE).append(SEPARATOR).append(super.toString()).append(SEPARATOR).append(obj).toString();
    }

    private HbaseKeyFactory(String description) {
        this.description = description;
    }

}
