/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.aspectj;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.developer.center.api.domain.dto.codereport.WhiteListCodePositionDto;
import cn.com.duiba.developer.center.api.remoteservice.codereport.RemoteWhiteListCodeReportService;
import cn.com.duiba.developer.center.api.utils.MD5;
import cn.com.duiba.developer.center.api.utils.WhiteAccessUtil;
import cn.com.duiba.developer.center.api.utils.WhiteAccessUtilBase;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.annotation.Resource;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class CustomCodeReportRunner
implements CommandLineRunner {
    private static final Logger logger = LoggerFactory.getLogger(CustomCodeReportRunner.class);
    @Resource
    private ExecutorService executorService;
    @Resource
    private WhiteAccessUtilBase whiteAccessUtilBase;
    @Autowired
    private Environment environment;
    @Autowired
    private RemoteWhiteListCodeReportService remoteWhiteListCodeReportService;

    public void run(String ... args) throws Exception {
        logger.info("\u81ea\u52a8\u4e0a\u62a5\u5b9a\u5236\u4ee3\u7801 \u5f00\u59cb");
        WhiteAccessUtilBase.sysName = this.environment.getProperty("spring.application.name");
        if (!SpringEnvironmentUtils.isProdEnv()) {
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.setTarget((Object)this.whiteAccessUtilBase);
            proxyFactory.addAdvice((Advice)new WhiteAccessUtilBase.WhiteAccessMethodInterceptor());
            WhiteAccessUtil.whiteAccessUtilBase = (WhiteAccessUtilBase)proxyFactory.getProxy();
            WhiteAccessUtilBase.static_executorService = this.executorService;
            WhiteAccessUtilBase.static_codeservice = this.remoteWhiteListCodeReportService;
            logger.info("WhiteAccessUtilBase \u4ee3\u7406\u8bbe\u7f6e\u5b8c\u6bd5");
        } else {
            WhiteAccessUtil.whiteAccessUtilBase = this.whiteAccessUtilBase;
        }
    }

    public static void collectPositionObject(String sysName, String className, String description, String value, List<WhiteListCodePositionDto> whiteListCodePositionDtoLists) {
        WhiteListCodePositionDto whiteListCodePositionDto = new WhiteListCodePositionDto();
        whiteListCodePositionDto.setCodePosition(className);
        whiteListCodePositionDto.setComment(description);
        whiteListCodePositionDto.setWhiteListKey(value);
        whiteListCodePositionDto.setSysName(sysName);
        whiteListCodePositionDto.setMd5Str(CustomCodeReportRunner.getMd5Str(value, sysName, className));
        whiteListCodePositionDtoLists.add(whiteListCodePositionDto);
    }

    public static String getMd5Str(String value, String sysName, String className) {
        return MD5.md5(value + sysName + className);
    }
}

