/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.domain.enums;

import cn.com.duiba.developer.center.api.domain.enums.FloorTypeEnum;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.List;

public enum FloorDataTypeEnum {
    BANNER_DEFAULT(FloorTypeEnum.Banner, 0, "\u9ed8\u8ba4banner"),
    ICON_DEFAULT(FloorTypeEnum.ICON, 0, "\u9ed8\u8ba4ICON"),
    GOODS_DEFAULT(FloorTypeEnum.Goods, 0, "\u5546\u54c1\u533a"),
    GOODS_PAGE(FloorTypeEnum.Goods, 1, "\u5546\u54c1\u533a\u5206\u9875"),
    ACTIVITY_PAGE(FloorTypeEnum.Activity, 0, "\u5b50\u9875\u9762\u6d3b\u52a8"),
    ACTIVITY_GROUP(FloorTypeEnum.Activity, 1, "\u6d3b\u52a8\u7ec4\u6d3b\u52a8"),
    ACTIVITY_OPERATING(FloorTypeEnum.Activity, 2, "\u5f00\u53d1\u8005\u5165\u5e93\u6d3b\u52a8"),
    COUPON_DEFAULT(FloorTypeEnum.Coupon, 0, "\u4f18\u60e0\u5238"),
    CUSTOM_DEFAULT(FloorTypeEnum.Custom, 0, "\u81ea\u5b9a\u4e49\u697c\u5c42"),
    CUSTOM_YAOFENG(FloorTypeEnum.Custom, 1, "\u8170\u5c01\u697c\u5c42"),
    CUSTOM_TOP(FloorTypeEnum.Custom, 2, "\u5438\u9876\u60ac\u6d6e"),
    CUSTOM_BOTTOM(FloorTypeEnum.Custom, 3, "\u5e95\u90e8\u60ac\u6d6e"),
    SHOWCASE_DEFAULT(FloorTypeEnum.ShowCase, 0, "\u9ed8\u8ba4\u6a71\u7a97"),
    GAME_DEFAULT(FloorTypeEnum.Game, 0, "\u6e38\u620f\u4e2d\u5fc3"),
    SECKILL_DEFAULT(FloorTypeEnum.Seckill, 0, "\u514d\u5355\u79d2\u6740"),
    SIGN_DEFAULT(FloorTypeEnum.Sign, 0, "\u666e\u901a\u7b7e\u5230"),
    TASK_DEFAULT(FloorTypeEnum.Task, 0, "\u9ed8\u8ba4"),
    APP_SECKILL_DEFAULT(FloorTypeEnum.AppSeckill, 0, "\u5f00\u53d1\u8005\u79d2\u6740\u697c\u5c42"),
    APP_SECKILL_FULLLIST(FloorTypeEnum.AppSeckill, 1, "\u5f00\u53d1\u8005\u79d2\u6740\u5b50\u9875\u9762"),
    APP_SECKILL_PARTTIME(FloorTypeEnum.AppSeckill, 2, "\u5f00\u53d1\u8005\u5206\u573a\u6b21\u79d2\u6740\u697c\u5c42"),
    APP_SECKILL_PARTTIME_FULLLIST(FloorTypeEnum.AppSeckill, 3, "\u5f00\u53d1\u8005\u5206\u573a\u6b21\u79d2\u6740\u5b50\u9875\u9762");

    private static Table<FloorTypeEnum, Integer, FloorDataTypeEnum> TABLE;
    private static ArrayListMultimap<FloorTypeEnum, FloorDataTypeEnum> TYPE_MAP;
    private FloorTypeEnum floorType;
    private Integer code;
    private String desc;

    private FloorDataTypeEnum(FloorTypeEnum floorType, Integer code, String desc) {
        this.floorType = floorType;
        this.code = code;
        this.desc = desc;
    }

    public static FloorDataTypeEnum getDataType(FloorTypeEnum floorType, Integer code) {
        return (FloorDataTypeEnum)((Object)TABLE.get((Object)floorType, (Object)code));
    }

    public static List<FloorDataTypeEnum> getFloorDataTypesByFloorType(FloorTypeEnum floorType) {
        return TYPE_MAP.get((Object)floorType);
    }

    public Integer getCode() {
        return this.code;
    }

    public FloorTypeEnum getFloorType() {
        return this.floorType;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        TABLE = HashBasedTable.create();
        TYPE_MAP = ArrayListMultimap.create();
        for (FloorDataTypeEnum item : FloorDataTypeEnum.values()) {
            TABLE.put((Object)item.floorType, (Object)item.code, (Object)item);
            TYPE_MAP.put((Object)item.floorType, (Object)item);
        }
    }
}

