package cn.com.duiba.developer.center.api.remoteservice.survey;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.survey.SurveyDto;
import cn.com.duiba.developer.center.api.domain.dto.survey.SurveySubmitDto;

@AdvancedFeignClient
public interface RemoteSurveyService {
    /**
     * 获取问券
     *
     * @param surveyId
     * @param version  不填则获取最新版本
     */
    SurveyDto getSurvey(Long surveyId, Integer version, Long consumerId, Long appId) throws BizException;

    /**
     * 提交问券
     *
     * @param surveySubmitDto
     * @return
     */
    Long submitSurvey(SurveySubmitDto surveySubmitDto) throws BizException;
}
