package cn.com.duiba.developer.center.api.domain.enums.survey;

import java.util.Objects;
import java.util.Optional;

/**
 * 问题类型
 */
public enum QuestionTypeEnum {
    FEEDBACK("feedback", "反馈", false, true),
    RADIO("radio", "单选", true, false),
    TEXT("text", "单行", false, false),
    TEXT_AREA("textarea", "多行文本", false, false),
    CHECKBOX("checkbox", "多选", true, false),
    SINGLE_LABEL("single_label", "单选标签", true, false),
    MULTI_LABEL("multi_label", "多选标签", true, false),
    STAR_RATING("star_rating", "星级评价", false, false),
    ;

    private final String type;
    private final String msg;
    /**
     * 是否必须有option
     */
    private final boolean requireOption;

    /**
     * 允许先提交
     */
    private final boolean allowEarlierSubmit;

    QuestionTypeEnum(String type, String msg, boolean requireOption, boolean allowEarlierSubmit) {
        this.type = type;
        this.msg = msg;
        this.requireOption = requireOption;
        this.allowEarlierSubmit = allowEarlierSubmit;
    }

    public String getType() {
        return type;
    }

    public String getMsg() {
        return msg;
    }

    public boolean isRequireOption() {
        return requireOption;
    }

    public static Optional<QuestionTypeEnum> getQuestionTypeEnumByType(String type) {
        for (QuestionTypeEnum value : QuestionTypeEnum.values()) {
            if (Objects.equals(value.getType(), type)) {
                return Optional.of(value);
            }
        }
        return Optional.empty();
    }


    @Override
    public String toString() {
        return type;
    }

    public boolean isAllowEarlierSubmit() {
        return allowEarlierSubmit;
    }
}
