package cn.com.duiba.developer.center.api.domain.dto.caselibrary;

import cn.com.duiba.api.enums.ActivityUniformityTypeEnum;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class CaseLibraryDto implements Serializable {
    private static final long serialVersionUID = 483791623909671845L;
    /**
     * 主键
     **/
    private Long id;
    /**
     * 案例类型
     **/
    private Integer caseType;
    /**
     * 活动或签到Id
     **/
    private Long activityId;
    /**
     * 活动类型
     * {@link ActivityUniformityTypeEnum#HDTool}  活动工具
     * {@link ActivityUniformityTypeEnum#ManageSign}  经营性签到
     * {@link ActivityUniformityTypeEnum#PetSign}  宠物养成
     * {@link ActivityUniformityTypeEnum#ContractSign}  契约签到
     * */
    private Integer activityType;
    /**
     * 案例图片
     **/
    private String casePhoto;
    /**
     * 案例标题
     **/
    private String caseTitle;

    private List<CaseTypeDto> sortType;
    /**
     * 公司名称
     **/
    private String companyName;
    /**
     * 公司logo
     **/
    private String companyLogo;
    /**
     * 案例动图
     **/
    private String caseGif;
    /**
     * 案例真实数据
     **/
    private String caseRealData;
    /**
     * 案例对外数据
     **/
    private String caseOutData;
    /**
     * 数据创建时间
     **/
    private Date gmtCreate;
    /**
     * 数据修改时间
     **/
    private Date gmtModified;


    public Integer getCaseType() {
        return caseType;
    }

    public void setCaseType(Integer caseType) {
        this.caseType = caseType;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getCasePhoto() {
        return casePhoto;
    }

    public void setCasePhoto(String casePhoto) {
        this.casePhoto = casePhoto;
    }

    public String getCaseTitle() {
        return caseTitle;
    }

    public void setCaseTitle(String caseTitle) {
        this.caseTitle = caseTitle;
    }

    public List<CaseTypeDto> getSortType() {
        return sortType;
    }

    public void setSortType(List<CaseTypeDto> sortType) {
        this.sortType = sortType;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getCompanyLogo() {
        return companyLogo;
    }

    public void setCompanyLogo(String companyLogo) {
        this.companyLogo = companyLogo;
    }

    public String getCaseGif() {
        return caseGif;
    }

    public void setCaseGif(String caseGif) {
        this.caseGif = caseGif;
    }

    public String getCaseRealData() {
        return caseRealData;
    }

    public void setCaseRealData(String caseRealData) {
        this.caseRealData = caseRealData;
    }

    public String getCaseOutData() {
        return caseOutData;
    }

    public void setCaseOutData(String caseOutData) {
        this.caseOutData = caseOutData;
    }

    public Integer getActivityType() {
        return activityType;
    }

    public void setActivityType(Integer activityType) {
        this.activityType = activityType;
    }

    @Override
    public String toString() {
        return "CaseLibraryDto{" +
                "id=" + id +
                ", caseType=" + caseType +
                ", activityId=" + activityId +
                ", casePhoto='" + casePhoto + '\'' +
                ", caseTitle='" + caseTitle + '\'' +
                ", sortType='" + sortType + '\'' +
                ", companyName='" + companyName + '\'' +
                ", companyLogo='" + companyLogo + '\'' +
                ", caseGif='" + caseGif + '\'' +
                ", caseRealData='" + caseRealData + '\'' +
                ", caseOutData='" + caseOutData + '\'' +
                ", gmtCreate=" + gmtCreate +
                ", gmtModified=" + gmtModified +
                '}';
    }
}
