package cn.com.duiba.developer.center.api.domain.enums.BasicSetting;

import java.util.Objects;

/**
 * @author JunAngLiu
 * @Title: AppEnvJudgeEnum
 * @Description:
 * @date 2019/5/912:03
 */
public enum AppEnvJudgeEnum {
    UA(1,"通过ua标识判断"),
    SPECIFIC(2,"通过特定方法判断");

    private Integer value;
    private String desc;

    public Integer getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    AppEnvJudgeEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static AppEnvJudgeEnum getEnumByValue(Integer value){
        if(Objects.isNull(value)){
            return null;
        }
        for (AppEnvJudgeEnum appEnvJudgeEnum:AppEnvJudgeEnum.values()) {
            if(Objects.equals(value,appEnvJudgeEnum.getValue())){
                return appEnvJudgeEnum;
            }
        }
        return null;
    }

}
