/**
 * Project Name:duiba-manager-common File Name:PushScourceTypeEnum.java Package
 * Name:cn.com.duiba.manager.web.common.enums Date:2016年11月2日下午8:14:11 Copyright (c) 2016, duiba.com.cn All Rights
 * Reserved.
 */

package cn.com.duiba.developer.center.api.domain.enums;

import org.apache.commons.lang.StringUtils;


/**
 * 计划任务推送内容类
 * Date: 2016年11月2日 下午8:14:11 <br/>
 * 
 * @author zhanglihui
 * @version
 * @since JDK 1.6
 * @see
 */
public enum PushSourceTypeEnum implements EnumInterface {//NOSONAR
    /** 轮播图banner */
    APP_SHOWCASE("appShowcase", false, "自定义橱窗图"),

    /** 轮播图banner */
    APP_BANNER("appBanner", false, "自定义banner"),

    /** 兑吧商品 */
    ITEM("item", false, "商品"),
    
    /** 开发者自有商品 */
    APP_ITEM("appItem", false, "商品"),

    /** 自定义链接 */
    URL("url", false, "自定义链接"),

    /** 兑吧单品抽奖 */
    SINGLE_LOTTERY("singleLottery", true, "单品抽奖"),

    /** 开发者单品抽奖 */
    APP_SINGLE_LOTTERY("appSingleLottery", true, "单品抽奖"),
    
    /** 活动工具,包括：摇一摇、刮刮卡、大转盘、砸彩蛋、老虎机、趣味翻牌 */
    HD_TOOL("hdtool", true, "活动工具"),
    
    /** 开发者活动工具，包括：圆形大转盘、方形大转盘、刮刮卡、砸彩蛋、老虎机、趣味翻牌 */
    APP_HD_TOOL("appHdtool", true, "活动工具"),

    /** 游戏 */
    NEW_GAME("ngame", true, "游戏"),

    /** 测试题 */
    QUIZZ("quizz", true, "测试题"),

    /** 竞猜 */
    GUESS("guess", true, "竞猜"),

    /** 答题 */
    QUESTION_ANSWER("questionAnswer", true, "答题"),
    
    /** 开发者答题活动 */
    APP_QUESTION_ANSWER("appQuestionAnswer", true, "答题"),
    
    /** 积分游戏 */
    Credit_Game("creditGame",true,"积分游戏"),

    /** 秒杀活动 */
    DUIBA_SECKILL("seckill", true, "秒杀活动"),

    /** 秒杀专题 */
    SECONDS_KILL_ACTIVITY("secondsKillActivity", true, "秒杀专题"),
    
    /** 开发者手动开奖活动 */
    APP_MANUAL_LOTTERY("appManualLottery", true, "手动开奖");
    
    /** 代码 */
    private String code;
    
    /** 活动是否必须入库——对于兑吧活动推送到开发者端时，必须先执行入库操作 */
    private boolean isActivity;

    /** 描述 */
    private String desc;

    private PushSourceTypeEnum(String code, boolean isActivity, String desc) {
        this.code = code;
        this.isActivity = isActivity;
        this.desc = desc;
    }

    /**
     * 根据主字段获取枚举类
     * @param code 枚举主字段
     * @return 枚举类
     */
    public static PushSourceTypeEnum getByCode(String code) {
        for (PushSourceTypeEnum enumVal : PushSourceTypeEnum.values()) {
            if (StringUtils.equals(code, enumVal.getCode())) {
                return enumVal;
            }
        }
        return null;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    /**
     * @return boolean
     */
    public boolean isActivity() {
        return isActivity;
    }
}
