package cn.com.duiba.developer.center.api.domain.enums.crm;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by 刘凯 on 2020/06/12.
 */
public enum ClueGroupTypeEnum {

    ALL_INDUSTRY(1,"全行业"),
    BANK(2,"银行"),
    GOVERMENT(3,"政企"),
    TAOBAO(4,"淘宝"),
    INSURANCE(5,"保险");

    private static final Map<Integer, ClueGroupTypeEnum> enumMap = new HashMap<>();
    static{
        for(ClueGroupTypeEnum clueGroupTypeEnum : values()){
            enumMap.put(clueGroupTypeEnum.getCode(), clueGroupTypeEnum);
        }
    }

    public static ClueGroupTypeEnum getByCode(Integer code){
        ClueGroupTypeEnum clueGroupTypeEnum = enumMap.get(code);
        if(clueGroupTypeEnum == null){
            return null;
        }
        return clueGroupTypeEnum;
    }

    ;

    private Integer code;
    private String desc;

    ClueGroupTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
