package cn.com.duiba.developer.center.api.domain.enums.crm;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by 刘凯 on 2020/06/12.
 */
public enum CluePurposeTypeEnum {
    UNKNOWN(1,"未知"),
    CREDITS(2,"积分商城"),
    CUSTOM_ACTIVITY(3,"定制活动"),



    ;
    private static final Map<Integer, CluePurposeTypeEnum> enumMap = new HashMap<>();
    static{
        for(CluePurposeTypeEnum cluePurposeTypeEnum : values()){
            enumMap.put(cluePurposeTypeEnum.getCode(), cluePurposeTypeEnum);
        }
    }

    public static CluePurposeTypeEnum getByCode(Integer code){
        CluePurposeTypeEnum cluePurposeTypeEnum = enumMap.get(code);
        if(cluePurposeTypeEnum == null){
            return null;
        }
        return cluePurposeTypeEnum;
    }


    private Integer code;
    private String desc;

    CluePurposeTypeEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
