package cn.com.duiba.developer.center.api.domain.param;

import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryParam;

import java.io.Serializable;

/**
 *
 * @author dugq
 * @date 2018/8/27
 */
public class VisualEditorAppSkinParam extends PageQueryParam implements Serializable {
    private static final long serialVersionUID = -3924321035025961187L;

    /**
     * 主键
     * 逻辑主键
     * isNullAble:0
     */
    private Long id;

    /**
     * 应用id
     * isNullAble:0,defaultVal:0
     */
    private Long appId;


    /**
     * 标识位(参考statusSwitch)
     * isNullAble:0,defaultVal:0
     */
    private Integer openStatus;


    /**
     * 皮肤类型(首页皮肤,活动皮肤)
     * isNullAble:1
     */
    private Integer skinType;

    /**
     * SkinModeEnum
     * 皮肤类型，是否悠闲查询备份数据
     * 如果优先查询,先查询备份，如果备份没有，返回源数据
     *
     */
    private Integer skinMode;
    /**
     * 临时数据的原数据id
     */
    private Long parentId;


    /**
     * 删除标志位(0-正常 1-删除)
     * isNullAble:0,defaultVal:0
     */
    private Integer deleted;

    /**
     * 皮肤名称（模糊查询）
     */
    private String skinName;

    public Integer getSkinMode() {
        return skinMode;
    }

    public void setSkinMode(Integer skinMode) {
        this.skinMode = skinMode;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getOpenStatus() {
        return openStatus;
    }

    public void setOpenStatus(Integer openStatus) {
        this.openStatus = openStatus;
    }

    public Integer getSkinType() {
        return skinType;
    }

    public void setSkinType(Integer skinType) {
        this.skinType = skinType;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public String getSkinName() {
        return skinName;
    }

    public void setSkinName(String skinName) {
        this.skinName = skinName;
    }
}
