package cn.com.duiba.developer.center.api.remoteservice.strategy;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.strategy.StrategyCaseIterationDto;

import java.util.List;

/**
 * 案例迭代-远程服务接口
 *
 * @Author: xuwei
 * @Date: 2020/05/27
 */
@AdvancedFeignClient
public interface RemoteStrategyCaseIterationService {

    /**
     * 保存迭代
     *
     * @param iterationDto
     * @return
     */
    Long save(StrategyCaseIterationDto iterationDto) throws BizException;

    /**
     * 根据案例Id查询迭代
     *
     * @param caseId 案例Id
     * @return
     */
    List<StrategyCaseIterationDto> list(Long caseId) throws BizException;

    boolean delete(Long id, String actorName) throws BizException;
}