/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.api.utils;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ParamEstimateUtils {
    private static Map<String, String> emailMap = Maps.newHashMap();
    private static final ImmutableSet<String> SQL_SET;

    private ParamEstimateUtils() {
    }

    public static String getEmailIndexURL(String email) {
        if (!ParamEstimateUtils.isEmail(email)) {
            return null;
        }
        String temp = email.substring(email.lastIndexOf(64) + 1);
        return emailMap.get(temp);
    }

    public static boolean isValid(String p) {
        if (StringUtils.isBlank((String)p)) {
            return true;
        }
        String upperCase = p.toUpperCase();
        for (String item : SQL_SET) {
            if (upperCase.indexOf(item) < 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmail(String email) {
        if (StringUtils.isBlank((String)email)) {
            return false;
        }
        Pattern p = Pattern.compile("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*");
        Matcher m = p.matcher(email);
        return m.matches();
    }

    public static boolean isPhone(String phone) {
        if (StringUtils.isEmpty((String)phone)) {
            return false;
        }
        if (phone.length() != 11) {
            return false;
        }
        Pattern p = Pattern.compile("[0-9]*");
        Matcher m = p.matcher(phone);
        return m.matches();
    }

    static {
        emailMap.put("qq.com", "http://mail.qq.com");
        emailMap.put("gmail.com", "http://mail.google.com");
        emailMap.put("sina.com", "http://mail.sina.com.cn");
        emailMap.put("163.com", "http://mail.163.com");
        emailMap.put("126.com", "http://mail.126.com");
        emailMap.put("yeah.net", "http://www.yeah.net");
        emailMap.put("sohu.com", "http://mail.sohu.com");
        emailMap.put("tom.com", "http://mail.tom.com");
        emailMap.put("sogou.com", "http://mail.sogou.com");
        emailMap.put("139.com", "http://mail.10086.cn");
        emailMap.put("hotmail.com", "http://www.hotmail.com");
        emailMap.put("live.com", "http://login.live.com");
        emailMap.put("live.cn", "http://login.live.cn");
        emailMap.put("live.com.cn", "http://login.live.com.cn");
        emailMap.put("189.com", "http://webmail16.189.cn/webmail");
        emailMap.put("yahoo.com.cn", "http://mail.cn.yahoo.com");
        emailMap.put("yahoo.cn", "http://mail.cn.yahoo.com");
        emailMap.put("eyou.com", "http://www.eyou.com");
        emailMap.put("21cn.com", "http://mail.21cn.com");
        emailMap.put("188.com", "http://www.188.com");
        emailMap.put("foxmail.coom", "http://www.foxmail.com");
        SQL_SET = ImmutableSet.of((Object)"DELETE", (Object)"ASCII", (Object)"UPDATE", (Object)"SELECT", (Object)"SUBSTR(", (Object)"COUNT(", (Object[])new String[]{" OR ", " AND ", "DROP", "EXECUTE", "EXEC", "TRUNCATE", "INTO", "DECLARE", "MASTER", "%"});
    }
}

