/**
 * Project Name:developer-center-api
 * File Name:AppPushStatusEnum.java
 * Package Name:cn.com.duiba.developer.center.api.domain.enums
 * Date:2016年11月2日下午9:51:11
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.developer.center.api.domain.enums.authority;

import com.google.common.collect.Lists;

import java.util.List;
import java.util.Objects;

/**
 * 业务活动权限关联枚举<br/>
 */
public enum RightBusinessTypeEnum {

    BASIC_SERVICE(1, "基础服务"),
    UNIT(2, "组件"),
    CMS_ACTIVITY(3, "营销落地页"),
    MARKET_ACTIVITY(4, "补给站活动"),
    FUNCTION_SPE(5, "功能特权"),
    FRONT_END_CUSTOM(6, " 前端多路由资源定制"),
    ACTIVITY_PLATFORM(7, "活动平台模版活动"),
    ;



    private Integer code;
    private String desc;

    RightBusinessTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static List<Integer> allKey = null;

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static List<Integer> getAllKeyValues(){
        if(allKey != null){
            return allKey;
        }
        List<Integer> allKeys = Lists.newArrayList();
        for(RightBusinessTypeEnum data:RightBusinessTypeEnum.values()){
            allKeys.add(data.getCode());
        }
        allKey = allKeys;
        return allKey;
    }

    public static RightBusinessTypeEnum getByValue(Integer value){
        if(value == null){
            return null;
        }
        for(RightBusinessTypeEnum rightBusinessTypeEnum:RightBusinessTypeEnum.values()){
            if(Objects.equals(rightBusinessTypeEnum.getCode(),value) ){
                return rightBusinessTypeEnum;
            }
        }
        return null;
    }
}

