package cn.com.duiba.developer.center.api.domain.enums.visualeditor;

import org.apache.commons.lang.ObjectUtils;

/**
 * Created by sunyan on 2019/4/29.
 * 商品/商品组排序类型
 */
public enum SortEnum {
    /**
     * 自定义
     */
    CUSTOM("custom","自定义"),
    CREDITS_DESC("creditsDesc","积分倒序"),
    CREDITS_ASC("creditsAsc","积分顺序"),
    FACE_PRICE_ASC("facePriceAsc","划线价顺序"),
    FACE_PRICE_DESC("facePriceDesc","划线价降序"),
    SALE_DESC("saleDesc","销量倒序"),
    SALE_ASC("saleAsc","销量升序"),
    SALE_PRICE_ASC("salePriceAsc","实际价格顺序"),
    SALE_PRICE_DESC("salePriceDesc","实际价格降序"),
    ;

    private String type;
    private String desc;

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    SortEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static SortEnum getByType(String type){
        if(type == null){
            return null;
        }
        for(SortEnum sortEnum:SortEnum.values()){
            if(ObjectUtils.equals(type,sortEnum.getType())){
                return sortEnum;
            }
        }
        return null;
    }
}
