package cn.com.duiba.developer.center.api.domain.dto.risk;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class RiskBlackListDto implements Serializable {

    private static final long serialVersionUID = 4990471255734851795L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 1 用户黑名单，2 ip黑名单
     */
    private Integer riskType;

    /**
     * 风控场景：1 提现，2 参与，3 发奖，4兑换
     */
    private Integer riskScene;

    /**
     * 根据类型：用户id或者ip
     */
    private String riskValue;

    /**
     * 修改人
     */
    private String modifier;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 备注
     */
    private String remarks;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Integer getRiskType() {
        return riskType;
    }

    public void setRiskType(Integer riskType) {
        this.riskType = riskType;
    }

    public Integer getRiskScene() {
        return riskScene;
    }

    public void setRiskScene(Integer riskScene) {
        this.riskScene = riskScene;
    }

    public String getRiskValue() {
        return riskValue;
    }

    public void setRiskValue(String riskValue) {
        this.riskValue = riskValue;
    }

    public String getModifier() {
        return modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RiskBlackListDto that = (RiskBlackListDto) o;
        return Objects.equals(appId, that.appId) &&
                Objects.equals(riskType, that.riskType) &&
                Objects.equals(riskScene, that.riskScene) &&
                Objects.equals(riskValue, that.riskValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appId, riskType, riskScene, riskValue);
    }
}