package cn.com.duiba.developer.center.api.remoteservice.authority;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.authority.ResourcesDto;
import cn.com.duiba.developer.center.api.domain.enums.authority.RightBusinessTypeEnum;
import cn.com.duiba.developer.center.api.domain.param.authority.ResourceTagDto;
import cn.com.duiba.developer.center.api.domain.param.authority.ResourcesDetailDto;
import cn.com.duiba.wolf.entity.Pair;

import java.util.List;

@AdvancedFeignClient
public interface RemoteResourcesService {



    /**
     *@Desc  新增
     *@params
     */
    Long save(ResourcesDto resourcesDto);


    /**
     *@Desc  根据名称 业务标签查询
     *@params
     */
    List<ResourcesDto> selectByNameAndTagId(String resourceName, RightBusinessTypeEnum rightBusinessTypeEnum);

    /**
     *@Desc  获取权限配置
     *@params VerisonAppInfoDto
     */
    List<ResourcesDetailDto> getNewResourceTagDtos();

    /**
     *@Desc  判断用户是否有购物车权限
     *@params VerisonAppInfoDto
     */
    Boolean accessNewVersionAuthorityShoppingCart(Long appId);



}
