package cn.com.duiba.developer.center.api.remoteservice.risk;

import cn.com.duiba.api.bo.page.Page;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.developer.center.api.domain.dto.risk.RiskBlackListDto;
import cn.com.duiba.developer.center.api.domain.param.RiskBlackListParam;

import java.util.List;

/**
 * @author XuJing
 * @since 2020/3/25 1:50 下午
 */
@AdvancedFeignClient
public interface RemoteRiskBlackListService {
    /**
     * 根据主键删除操作
     *
     * @param id
     * @return
     */
    int deleteByPrimaryKey(Long id);

    /**
     * 插入操作
     *
     * @param record
     * @return
     */
    int insert(RiskBlackListDto record);

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    RiskBlackListDto selectByPrimaryKey(Long id);

    /**
     * 更新操作（空值不更新）
     *
     * @param record
     * @return
     */
    int updateByPrimaryKeySelective(RiskBlackListDto record);

    /**
     * 批量新增
     *
     * @param list
     * @return
     */
    int batchInsert(List<RiskBlackListDto> list);

    /**
     * 分页查询
     *
     * @param riskBlackListParam
     * @return
     */
    Page<RiskBlackListDto> listByPage(RiskBlackListParam riskBlackListParam);

    /**
     * 查询数据库是否唯一键冲突
     *
     * @return
     */
    Boolean checkOnly(Long appId, Integer riskType, Integer riskScene, String riskValue);

    /**
     * 判断是否在黑名单中
     *
     * @return
     */
    Boolean riskBlacklistMatching(Long appId, Integer riskScene, String ip, Long customerId);
}
