/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.bo.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.paramquery.CreateAppQueryParams;
import cn.com.duiba.developer.center.biz.bo.AppBo;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppDO;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppExtraDO;
import cn.com.duiba.developer.center.biz.event.AppCreateEvent;
import cn.com.duiba.developer.center.biz.service.AppExtraService;
import cn.com.duiba.developer.center.biz.service.AppService;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import cn.com.duiba.developer.center.common.tools.AppIdGenerator;
import cn.com.duiba.developer.center.common.tools.SecureTool;
import cn.com.duiba.developer.center.common.tools.SwicthTool;
import cn.com.duiba.service.exception.BusinessException;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppBoImpl
implements AppBo {
    @Resource
    private AppService appService;
    @Resource
    private AppExtraService appExtraService;
    @Autowired
    private BizEventBus eventBus;

    @Override
    public Long createApp(CreateAppQueryParams params) throws BusinessException {
        Integer appCount = this.appService.findAppCountByDevId(params.getDeveloperId());
        if (appCount > 10) {
            throw new BusinessException("\u521b\u5efa\u7684\u5e94\u7528\u4e0d\u80fd\u8d85\u8fc710\u4e2a");
        }
        AppDO app = new AppDO(true);
        app.setName(params.getName());
        app.setCreditsRate(params.getCreditsRate());
        app.setAppKey(AppIdGenerator.generate());
        String appSecretCode = AppIdGenerator.generate();
        app.setAppSecretCode(SecureTool.encryptAppSecret((String)appSecretCode));
        app.setDeveloperId(params.getDeveloperId());
        app.setBudget(null);
        app.setBudgetRemain(null);
        app.setDayBudget(null);
        app.setDayBudgetRemain(null);
        app.setUnitName(params.getUnitName());
        List categoryList = params.getCategory();
        app.setCategory1((String)categoryList.get(0));
        if (categoryList.size() == 2) {
            app.setCategory2((String)categoryList.get(1));
        }
        this.appService.insert(app);
        SwicthTool tool = SwicthTool.getSwicthTool((Long)app.getId(), (Integer)app.getAppSwitch());
        tool.setSwicthByBoundType(6, true);
        tool.setSwicthByBoundType(9, true);
        tool.setSwicthByBoundType(10, true);
        tool.setSwicthByBoundType(11, true);
        this.appService.updateSwitch(tool);
        AppCreateEvent event = new AppCreateEvent(app);
        this.eventBus.post((Object)event);
        return app.getId();
    }

    @Override
    @Transactional(value="credits")
    public void updateAppConfig(Long appId, String entranceDesc, String callLoginProgram, String appType, String useloginCode, String freeItemVip, String exchangeCreditsType) {
        AppExtraDO appExtraDO = this.appExtraService.findByAppId(appId);
        if (null == appExtraDO) {
            appExtraDO = new AppExtraDO();
            appExtraDO.setAppId(appId);
            appExtraDO.setEntranceDesc(entranceDesc);
            appExtraDO.setCallLoginProgram(callLoginProgram);
            this.appExtraService.insertAppConfig(appExtraDO);
        } else {
            this.appExtraService.updateAppConfig(appId, entranceDesc, callLoginProgram);
        }
        AppSimpleDto app = this.appService.findForUpdate(appId);
        SwicthTool tool = SwicthTool.getSwicthTool((Long)app.getId(), (Integer)app.getAppSwitch());
        tool.setSwicthByBoundType(12, "on".equals(appType));
        tool.setSwicthByBoundType(13, "on".equals(useloginCode));
        tool.setSwicthByBoundType(14, "on".equals(freeItemVip));
        tool.setSwicthByBoundType(16, "on".equals(exchangeCreditsType));
        this.appService.updateSwitch(tool);
    }

    @Override
    public AppSimpleDto getSimpleApp(Long id) {
        return this.appService.findCacheApp(id);
    }

    @Override
    public String getAppSecret(Long appId) {
        return null;
    }
}

