/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.bo.impl;

import cn.com.duiba.developer.center.api.domain.manager.InternalLetterDO;
import cn.com.duiba.developer.center.api.domain.manager.InternalLetterKeyDO;
import cn.com.duiba.developer.center.api.domain.paramquery.InternalLetterQueryEntity;
import cn.com.duiba.developer.center.api.domain.paramquery.PageQueryEntity;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.biz.bo.InternalLetterBo;
import cn.com.duiba.developer.center.biz.runnble.InternalLetterTask;
import cn.com.duiba.developer.center.biz.service.InternalLetterKeyService;
import cn.com.duiba.developer.center.biz.service.InternalLetterService;
import cn.com.duiba.developer.center.common.support.ThreadPoolDuibaService;
import cn.com.duiba.service.exception.BusinessException;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InternalLetterBoImpl
implements InternalLetterBo,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(InternalLetterBoImpl.class);
    private ApplicationContext applicationContext;
    private Splitter spl = Splitter.on((String)",").trimResults().omitEmptyStrings();
    @Autowired
    private InternalLetterService internalLetterService;
    @Autowired
    private InternalLetterKeyService internalLetterKeyService;
    @Autowired
    private ThreadPoolDuibaService threadPoolDuibaService;
    private ScheduledExecutorService timeService = Executors.newSingleThreadScheduledExecutor();

    @PostConstruct
    private void init() {
        this.timeService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    List<Long> ids = InternalLetterBoImpl.this.internalLetterService.findAllCanPushIds();
                    if (ids.isEmpty()) {
                        return;
                    }
                    Iterator<Long> it = ids.iterator();
                    while (it.hasNext()) {
                        InternalLetterBoImpl.this.pushTask(it.next());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u7ad9\u5185\u4fe1\u626b\u63cf\u5931\u8d25", (Throwable)e);
                }
            }
        }, 5L, 5L, TimeUnit.MINUTES);
    }

    @Override
    @Transactional(value="manager")
    public void submitInternalLetter(Optional<InternalLetterDO> letter) throws BusinessException {
        InternalLetterDO letterDO = (InternalLetterDO)letter.get();
        if (Objects.equal((Object)1, (Object)letterDO.getSendWay())) {
            if (Objects.equal(null, (Object)letterDO.getSendTime())) {
                throw new BusinessException("\u5b9a\u65f6\u53d1\u9001\u5fc5\u987b\u6307\u5b9a\u53d1\u9001\u65f6\u95f4");
            }
            if (new Date().after(letterDO.getSendTime())) {
                throw new BusinessException("\u5b9a\u65f6\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4");
            }
        } else {
            letterDO.setSendTime(new Date());
        }
        if (Objects.equal(null, (Object)letterDO.getId())) {
            this.internalLetterService.insert(letterDO);
        } else {
            InternalLetterDO old = this.internalLetterService.findForUpdate(letterDO.getId());
            if (Objects.equal(null, (Object)old) || old.getDeleted().booleanValue()) {
                throw new BusinessException("\u8be5\u7ad9\u5185\u4fe1\u5df2\u7ecf\u4e0d\u5b58\u5728");
            }
            if (1 == old.getSendStatue()) {
                throw new BusinessException("\u5df2\u7ecf\u53d1\u9001\u7684\u7ad9\u5185\u4fe1\u4e0d\u53ef\u7f16\u8f91");
            }
            this.internalLetterService.update(letterDO);
        }
        if (Objects.equal((Object)0, (Object)letterDO.getSendWay())) {
            this.pushTask(letterDO.getId());
        }
    }

    @Override
    @Transactional(value="manager")
    public void deleteInternalLette(Long letterId) throws BusinessException {
        InternalLetterDO letter = this.internalLetterService.findForUpdate(letterId);
        if (Objects.equal(null, (Object)letter)) {
            throw new BusinessException("\u6240\u8981\u5220\u9664\u7684\u7ad9\u5185\u4fe1\u4e0d\u5b58\u5728");
        }
        this.internalLetterService.delete(letter);
        if (Objects.equal((Object)1, (Object)letter.getSendStatue())) {
            this.internalLetterKeyService.batchDelete(letter.getId());
        }
    }

    @Override
    public void deleteInternalLette(Long developerId, Long letterId) throws BusinessException {
        this.internalLetterKeyService.deleteOne(letterId, developerId);
    }

    @Override
    public PaginationVO<InternalLetterDO> getInternalLetterPage(InternalLetterQueryEntity param) {
        List<InternalLetterDO> list = this.internalLetterService.findListPage((PageQueryEntity)param);
        Long count = this.internalLetterService.findCountPage((PageQueryEntity)param);
        PaginationVO page = new PaginationVO();
        page.setRows(list);
        page.setTotalCount(count);
        return page;
    }

    @Override
    public PaginationVO<InternalLetterKeyDO> getInternalLetterKeyPage(InternalLetterQueryEntity param) {
        List<InternalLetterKeyDO> list = this.internalLetterKeyService.findPage((PageQueryEntity)param);
        Long count = this.internalLetterKeyService.findPageCount((PageQueryEntity)param);
        PaginationVO page = new PaginationVO();
        page.setRows(list);
        page.setTotalCount(count);
        return page;
    }

    @Override
    public int setAllReaded(Long developerId) {
        return this.internalLetterKeyService.updateAllReaded(developerId);
    }

    @Override
    public InternalLetterDO developerFindInternalLetter(Long developerId, Long letterId) {
        this.internalLetterKeyService.updateOneReaded(letterId, developerId);
        return this.internalLetterService.find(letterId);
    }

    @Override
    public InternalLetterDO find(Long letterId) {
        return this.internalLetterService.find(letterId);
    }

    @Override
    public Integer getNoRead(Long developerId) {
        Integer count = this.internalLetterKeyService.getNoRead(developerId);
        return count;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private void pushTask(Long letterId) {
        InternalLetterTask task = (InternalLetterTask)this.applicationContext.getBean(InternalLetterTask.class);
        if (Objects.equal(null, (Object)task)) {
            throw new RuntimeException("\u7ad9\u5185\u4fe1\u4efb\u52a1\u672a\u914d\u7f6e");
        }
        task.setLetterId(letterId);
        this.threadPoolDuibaService.submit((Runnable)task, 1);
    }
}

