/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.remoteservice.impl;

import cn.com.duiba.developer.center.api.domain.dto.DlpIncomeDetailDto;
import cn.com.duiba.developer.center.api.domain.dto.ManualChargeApplyDto;
import cn.com.duiba.developer.center.api.domain.dto.RechargeOrdersDto;
import cn.com.duiba.developer.center.api.domain.dto.RemainingMoneyDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteDeveloperAccountService;
import cn.com.duiba.developer.center.biz.entity.ManualChargeApplyEntity;
import cn.com.duiba.developer.center.biz.entity.RechargeOrdersEntity;
import cn.com.duiba.developer.center.biz.entity.RemainingMoneyEntity;
import cn.com.duiba.developer.center.biz.service.DeveloperAccountService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.ObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteDeveloperAccountServiceImpl
implements RemoteDeveloperAccountService {
    private static Logger log = LoggerFactory.getLogger(RemoteDeveloperAccountService.class);
    @Autowired
    private DeveloperAccountService developerAccountService;

    public DubboResult<RemainingMoneyDto> findRemainingMoney(Long developerId) {
        return null;
    }

    public DubboResult<DlpIncomeDetailDto> findIncomeDetail(Long developerId) {
        return null;
    }

    public DubboResult<Long> addRechargeOrder(RechargeOrdersDto order) {
        try {
            RechargeOrdersEntity ro = new RechargeOrdersEntity();
            ObjectUtil.convert((Object)order, (Object)ro);
            Long ret = this.developerAccountService.addRechargeOrder(ro);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("addRechargeOrder error ", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<RemainingMoneyDto> findDeveloperRemainingMoney(Long developerId) {
        try {
            RemainingMoneyDto rm = new RemainingMoneyDto();
            RemainingMoneyEntity ret = this.developerAccountService.findDeveloperRemainingMoney(developerId);
            ObjectUtil.convert((Object)ret, (Object)rm);
            return DubboResult.successResult((Object)rm);
        }
        catch (Exception e) {
            log.error("findDeveloperRemainingMoney error developerId:" + developerId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<RechargeOrdersDto> findRechargeOrder(Long orderId) {
        try {
            RechargeOrdersDto rm = new RechargeOrdersDto();
            RechargeOrdersEntity ret = this.developerAccountService.findRechargeOrder(orderId);
            ObjectUtil.convert((Object)ret, (Object)rm);
            return DubboResult.successResult((Object)rm);
        }
        catch (Exception e) {
            log.error("addRechargeOrder findRechargeOrder orderId:" + orderId, (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> updateRechargeOrder(RechargeOrdersDto order) {
        try {
            RechargeOrdersEntity ro = new RechargeOrdersEntity();
            ObjectUtil.convert((Object)order, (Object)ro);
            Long ret = this.developerAccountService.updateRechargeOrder(ro);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("addRechargeOrder updateRechargeOrder ", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> saveManualChargeApply(ManualChargeApplyDto manualChargeApplyDto) {
        try {
            ManualChargeApplyEntity mca = new ManualChargeApplyEntity();
            ObjectUtil.convert((Object)manualChargeApplyDto, (Object)mca);
            Long ret = this.developerAccountService.saveManualChargeApply(mca);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("addRechargeOrder saveManualChargeApply ", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Long> updateManualChargeApply(ManualChargeApplyDto manualChargeApplyDto) {
        try {
            ManualChargeApplyEntity mca = new ManualChargeApplyEntity();
            ObjectUtil.convert((Object)manualChargeApplyDto, (Object)mca);
            Long ret = this.developerAccountService.updateManualChargeApply(mca);
            return DubboResult.successResult((Object)ret);
        }
        catch (Exception e) {
            log.error("addRechargeOrder updateManualChargeApply", (Throwable)e);
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

