/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.remoteservice.impl;

import cn.com.duiba.developer.center.api.domain.manager.InternalLetterDO;
import cn.com.duiba.developer.center.api.domain.manager.InternalLetterKeyDO;
import cn.com.duiba.developer.center.api.domain.paramquery.InternalLetterQueryEntity;
import cn.com.duiba.developer.center.api.domain.vo.PaginationVO;
import cn.com.duiba.developer.center.api.remoteservice.RemoteInternalLetterService;
import cn.com.duiba.developer.center.biz.bo.InternalLetterBo;
import cn.com.duiba.developer.center.common.tools.ValidatorTool;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteInternalLetterServiceImpl
implements RemoteInternalLetterService {
    @Autowired
    private InternalLetterBo internalLetterBo;

    public DubboResult<Boolean> saveInternalLetter(InternalLetterDO letter) {
        try {
            ValidatorTool.valid((Object)letter);
            this.internalLetterBo.submitInternalLetter((Optional<InternalLetterDO>)Optional.of((Object)letter));
            return DubboResult.successResult((Object)true);
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> deleteInternalLetter(Long letterId) {
        try {
            this.internalLetterBo.deleteInternalLette(letterId);
            return DubboResult.successResult((Object)true);
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> deleteInternalLetter(Long developerId, Long letterId) {
        try {
            this.internalLetterBo.deleteInternalLette(developerId, letterId);
            return DubboResult.successResult((Object)true);
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<InternalLetterDO> getOneInternalLetter(Long letterId) {
        return DubboResult.successResult((Object)this.internalLetterBo.find(letterId));
    }

    public DubboResult<PaginationVO<InternalLetterDO>> getInternalLetterPage(InternalLetterQueryEntity param) {
        return DubboResult.successResult(this.internalLetterBo.getInternalLetterPage(param));
    }

    public DubboResult<PaginationVO<InternalLetterKeyDO>> getInternalLetterKeyPage(InternalLetterQueryEntity param) {
        if (Objects.equal(null, (Object)param.getDeveloperId())) {
            return DubboResult.failResult((String)"\u52a0\u8f7d\u5f00\u53d1\u8005\u7ad9\u5185\u4fe1\u5217\u8868\u5fc5\u987b\u6307\u5b9a\u5f00\u53d1\u8005Id\u53f7");
        }
        PaginationVO<InternalLetterKeyDO> page = this.internalLetterBo.getInternalLetterKeyPage(param);
        return DubboResult.successResult(page);
    }

    public DubboResult<Integer> setAllReaded(Long developerId) {
        return DubboResult.successResult((Object)this.internalLetterBo.setAllReaded(developerId));
    }

    public DubboResult<InternalLetterDO> developerFindInternalLetter(Long developerId, Long letterId) {
        return DubboResult.successResult((Object)this.internalLetterBo.developerFindInternalLetter(developerId, letterId));
    }

    public DubboResult<Integer> getNoRead(Long developerId) {
        return DubboResult.successResult((Object)this.internalLetterBo.getNoRead(developerId));
    }
}

