/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.bo.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppBudgetDto;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.dto.AppUrlDto;
import cn.com.duiba.developer.center.api.domain.paramquery.AppInfoFromParams;
import cn.com.duiba.developer.center.api.domain.paramquery.CreateAppQueryParams;
import cn.com.duiba.developer.center.biz.bo.AppBo;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppDO;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppExtraDO;
import cn.com.duiba.developer.center.biz.event.AppCreateEvent;
import cn.com.duiba.developer.center.biz.event.AppUpdateEvent;
import cn.com.duiba.developer.center.biz.service.credits.AppBudgetService;
import cn.com.duiba.developer.center.biz.service.credits.AppExtraService;
import cn.com.duiba.developer.center.biz.service.credits.AppService;
import cn.com.duiba.developer.center.common.support.BizEventBus;
import cn.com.duiba.developer.center.common.tools.AppIdGenerator;
import cn.com.duiba.developer.center.common.tools.SecureTool;
import cn.com.duiba.developer.center.common.tools.SwicthTool;
import cn.com.duiba.service.exception.BusinessException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppBoImpl
implements AppBo {
    @Autowired
    private AppService appService;
    @Autowired
    private AppExtraService appExtraService;
    @Autowired
    private AppBudgetService appBudgetService;
    @Autowired
    private BizEventBus eventBus;

    @Override
    public Long createApp(CreateAppQueryParams params) throws BusinessException {
        Integer appCount = this.appService.findAppCountByDevId(params.getDeveloperId());
        if (appCount > 10) {
            throw new BusinessException("\u9352\u6d98\u7f13\u9428\u52eb\u7c32\u9422\u3124\u7b09\u9473\u501f\u79f4\u6769\ufffd10\u6d93\ufffd");
        }
        AppDO app = new AppDO(true);
        app.setName(params.getName());
        app.setCreditsRate(params.getCreditsRate());
        app.setAppKey(AppIdGenerator.generate());
        String appSecretCode = AppIdGenerator.generate();
        app.setAppSecretCode(SecureTool.encryptAppSecret((String)appSecretCode));
        app.setDeveloperId(params.getDeveloperId());
        app.setBudget(null);
        app.setBudgetRemain(null);
        app.setDayBudget(null);
        app.setDayBudgetRemain(null);
        app.setUnitName(params.getUnitName());
        List categoryList = params.getCategory();
        app.setCategory1((String)categoryList.get(0));
        if (categoryList.size() == 2) {
            app.setCategory2((String)categoryList.get(1));
        }
        this.appService.insert(app);
        SwicthTool tool = SwicthTool.getSwicthTool((Long)app.getId(), (Integer)app.getAppSwitch());
        tool.setSwicthByBoundType(6, true);
        tool.setSwicthByBoundType(9, true);
        tool.setSwicthByBoundType(10, true);
        tool.setSwicthByBoundType(11, true);
        this.appService.updateSwitch(tool);
        AppCreateEvent event = new AppCreateEvent(app);
        this.eventBus.post((Object)event);
        return app.getId();
    }

    @Override
    @Transactional(value="credits")
    public void updateAppConfig(Long appId, String entranceDesc, String callLoginProgram, String appType, String useloginCode, String freeItemVip, String exchangeCreditsType) {
        AppExtraDO appExtraDO = this.appExtraService.findByAppId(appId);
        if (null == appExtraDO) {
            appExtraDO = new AppExtraDO();
            appExtraDO.setAppId(appId);
            appExtraDO.setEntranceDesc(entranceDesc);
            appExtraDO.setCallLoginProgram(callLoginProgram);
            this.appExtraService.insertAppConfig(appExtraDO);
        } else {
            this.appExtraService.updateAppConfig(appId, entranceDesc, callLoginProgram);
        }
        AppSimpleDto app = this.appService.findForUpdate(appId);
        SwicthTool tool = SwicthTool.getSwicthTool((Long)app.getId(), (Integer)app.getAppSwitch());
        tool.setSwicthByBoundType(12, "on".equals(appType));
        tool.setSwicthByBoundType(13, "on".equals(useloginCode));
        tool.setSwicthByBoundType(14, "on".equals(freeItemVip));
        tool.setSwicthByBoundType(16, "on".equals(exchangeCreditsType));
        this.appService.updateSwitch(tool);
    }

    @Override
    public AppSimpleDto getSimpleApp(Long id) {
        return (AppSimpleDto)this.appService.getObject(id);
    }

    @Override
    @Transactional(value="credits")
    public void appInfo(AppInfoFromParams params) throws BusinessException {
        AppSimpleDto app = this.appService.findForUpdate(params.getAppId());
        if (Objects.equals(null, app)) {
            throw new BusinessException("\u93bb\u612a\u6c26\u9428\u51d9ppId\u6d93\u5d85\u74e8\u9366\ufffd");
        }
        AppDO app4u = new AppDO(params.getAppId());
        app4u.setName(params.getAppName());
        app4u.setTitle(params.getAppTitle());
        app4u.setLogo(params.getLogo());
        app4u.setCreditsRate(params.getCreditsRate());
        app4u.setUnitName(params.getUnitName());
        app4u.setCategory1(params.getCategory1());
        app4u.setCategory2(params.getCategory2());
        app4u.setEarnCreditsUrl(params.getEarnCreditsUrl());
        this.appService.updata(app4u);
        SwicthTool tool = SwicthTool.getSwicthTool((Long)params.getAppId(), (Integer)app.getAppSwitch());
        tool.setSwicthByBoundType(8, params.getCreditsDecimalPoint().booleanValue());
        tool.setSwicthByBoundType(12, params.getCreditsType().booleanValue());
        this.appService.updateSwitch(tool);
        AppUpdateEvent event = new AppUpdateEvent(params.getAppId());
        this.eventBus.post((Object)event);
    }

    @Override
    public void apiConfig(AppUrlDto urlDto) throws BusinessException {
        String creditsRemainQueryUrl;
        Long appId = urlDto.getId();
        AppSimpleDto app = this.appService.findForUpdate(appId);
        if (Objects.equals(null, app)) {
            throw new BusinessException("app\u6d93\u5d85\u74e8\u9366\ufffd");
        }
        AppDO update = new AppDO(app.getId());
        update.setId(appId);
        if (app.isAppSwitch(18)) {
            creditsRemainQueryUrl = StringUtils.isNotBlank((String)urlDto.getCreditsRemainQueryUrl()) ? urlDto.getCreditsRemainQueryUrl() : null;
            update.setCreditsRemainQueryUrl(creditsRemainQueryUrl);
            String virtualUrl = StringUtils.isNotBlank((String)urlDto.getVirtualExchangeUrl()) ? urlDto.getVirtualExchangeUrl() : null;
            update.setVirtualExchangeUrl(virtualUrl);
        } else {
            creditsRemainQueryUrl = StringUtils.isNotBlank((String)urlDto.getCreditsRemainQueryUrl()) ? urlDto.getCreditsRemainQueryUrl() : "";
            update.setCreditsRemainQueryUrl(creditsRemainQueryUrl);
            String creditsConsumeNotifyUrl = StringUtils.isNotBlank((String)urlDto.getCreditsConsumeNotifyUrl()) ? urlDto.getCreditsConsumeNotifyUrl() : "";
            update.setCreditsConsumeNotifyUrl(creditsConsumeNotifyUrl);
            String creditsConsumeRequestUrl = StringUtils.isNotBlank((String)urlDto.getCreditsConsumeRequestUrl()) ? urlDto.getCreditsConsumeRequestUrl() : "";
            update.setCreditsConsumeRequestUrl(creditsConsumeRequestUrl);
            String virtualUrl = StringUtils.isNotBlank((String)urlDto.getVirtualExchangeUrl()) ? urlDto.getVirtualExchangeUrl() : "";
            update.setVirtualExchangeUrl(virtualUrl);
        }
        update.checkApiEnableUpdate();
        this.appService.updata(update);
        AppUpdateEvent event = new AppUpdateEvent(app.getId());
        this.eventBus.post((Object)event);
    }

    @Override
    public void budgetConfig(AppBudgetDto appBudget) throws BusinessException {
        this.appBudgetService.updateForDeveloperBack(appBudget);
    }
}

