/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.bo.impl;

import cn.com.duiba.developer.center.api.domain.dto.AmbDeveloperWithdrawCashAuditDto;
import cn.com.duiba.developer.center.api.domain.dto.AmbDeveloperWithdrawCashOrderDto;
import cn.com.duiba.developer.center.api.domain.paramquery.WithdrawCashParams;
import cn.com.duiba.developer.center.biz.bo.DevWithdrawCashBo;
import cn.com.duiba.developer.center.biz.service.credits.AmbDeveloperWithdrawCashAuditService;
import cn.com.duiba.developer.center.biz.service.credits.AmbDeveloperWithdrawCashOrderService;
import cn.com.duiba.service.exception.BusinessException;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Service
public class DevWithdrawCashBoImpl
implements DevWithdrawCashBo {
    @Autowired
    private PlatformTransactionManager creditsTransactionManager;
    @Autowired
    private AmbDeveloperWithdrawCashAuditService ambDeveloperWithdrawCashAuditService;
    @Autowired
    private AmbDeveloperWithdrawCashOrderService ambDeveloperWithdrawCashOrderService;

    @Override
    public void firstWithdrawToBankOrAlipay(WithdrawCashParams withdrawCashParams, AmbDeveloperWithdrawCashAuditDto cashAuditDO, AmbDeveloperWithdrawCashOrderDto cashOrderDO) throws Exception {
        TransactionStatus transaction = this.creditsTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        try {
            AmbDeveloperWithdrawCashAuditDto auditing = this.ambDeveloperWithdrawCashAuditService.findAuditing(withdrawCashParams.getDeveloperId(), withdrawCashParams.getCashType());
            if (auditing != null) {
                throw new BusinessException("\u7487\u30e6\u5f41\u941c\u7248\u67df\u5bee\u5fd3\u51e1\u7f01\u5fd3\u74e8\u9366\u3125\ue178\u93cd\u9550\u8151\u9428\u52ed\u6575\u7487\u51e4\u7d1d\u6d93\u5d88\u5158\u95b2\u5d85\ue632\u9422\u5ba0\ue1ec\u951b\ufffd");
            }
            this.ambDeveloperWithdrawCashAuditService.disableValidPassAudit(withdrawCashParams.getDeveloperId(), withdrawCashParams.getCashType());
            cashAuditDO = new AmbDeveloperWithdrawCashAuditDto(true);
            cashAuditDO.setDeveloperId(withdrawCashParams.getDeveloperId());
            cashAuditDO.setCashType(withdrawCashParams.getCashType());
            cashAuditDO.setBusinessLicencePic(withdrawCashParams.getBusinessLicencePic());
            cashAuditDO.setIdCardFrontPic(withdrawCashParams.getIdCardFrontPic());
            cashAuditDO.setIdCardBackPic(withdrawCashParams.getIdCardBackPic());
            cashAuditDO.setBank(withdrawCashParams.getBank());
            cashAuditDO.setBankProvince(withdrawCashParams.getBankProvince());
            cashAuditDO.setBankCity(withdrawCashParams.getBankCity());
            cashAuditDO.setBankBranchName(withdrawCashParams.getBankBranchName());
            cashAuditDO.setBankAccountNumber(withdrawCashParams.getBankAccountNumber());
            cashAuditDO.setBankAccountName(withdrawCashParams.getBankAccountName());
            cashAuditDO.setAlipayAccountName(withdrawCashParams.getAlipayAccountName());
            cashAuditDO.setAlipayAccountNumber(withdrawCashParams.getAlipayAccountNumber());
            cashAuditDO.setStatus("create");
            cashAuditDO.setRegisterEmail(withdrawCashParams.getRegisterEmail());
            cashAuditDO.setPhone(withdrawCashParams.getPhone());
            this.ambDeveloperWithdrawCashAuditService.insert(cashAuditDO);
            cashOrderDO = new AmbDeveloperWithdrawCashOrderDto(true);
            cashOrderDO.setDeveloperId(withdrawCashParams.getDeveloperId());
            cashOrderDO.setMoney(Long.valueOf(new BigDecimal("100").multiply(new BigDecimal(withdrawCashParams.getMoney())).longValue()));
            cashOrderDO.setStatus("create");
            cashOrderDO.setRequiredAudit(Boolean.valueOf(true));
            cashOrderDO.setAuditId(cashAuditDO.getId());
            if ("alipay".equals(cashAuditDO.getCashType())) {
                cashOrderDO.setDescription("\u93bb\u612e\u5e47\u9352\u7248\u656e\u6d60\u6a3a\u7582\u951b\ufffd" + cashAuditDO.getAlipayAccountNumber());
            } else if ("bank".equals(cashAuditDO.getCashType())) {
                cashOrderDO.setDescription("\u93bb\u612e\u5e47\u9352\u4f34\u6471\u741b\u5c7d\u5d31\u951b\ufffd" + cashAuditDO.getBankAccountNumber());
            }
            this.ambDeveloperWithdrawCashOrderService.insert(cashOrderDO);
        }
        catch (Exception e) {
            transaction.setRollbackOnly();
            throw e;
        }
        finally {
            this.creditsTransactionManager.commit(transaction);
        }
    }

    @Override
    public void updateAuditAndOrderStatus(AmbDeveloperWithdrawCashAuditDto cashAuditDO, AmbDeveloperWithdrawCashOrderDto cashOrderDO) throws Exception {
        TransactionStatus transactionA = this.creditsTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
        try {
            this.ambDeveloperWithdrawCashOrderService.updateStatusCreateToWaitPay(cashOrderDO.getId());
            this.ambDeveloperWithdrawCashAuditService.updateStatusCreateToWait(cashAuditDO.getId());
        }
        catch (Exception e) {
            transactionA.setRollbackOnly();
            throw e;
        }
        finally {
            this.creditsTransactionManager.commit(transactionA);
        }
    }
}

