/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.dao.app.impl;

import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.vo.AppDeveloperVO;
import cn.com.duiba.developer.center.api.domain.vo.AppManageVO;
import cn.com.duiba.developer.center.biz.dao.app.AppDao;
import cn.com.duiba.developer.center.biz.dataobject.credits.AppDO;
import cn.com.duiba.developer.center.common.dao.BaseDao;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;

@Repository
public class AppDaoImpl
extends BaseDao
implements AppDao {
    @Override
    public List<AppSimpleDto> findByIds(List<Long> ids) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        map.put("ids", ids);
        return this.selectList("findByIds", map);
    }

    @Override
    public List<AppSimpleDto> findAll() {
        return this.selectList("findAll");
    }

    @Override
    public AppSimpleDto find(Long id) {
        return (AppSimpleDto)this.selectOne("find", id);
    }

    @Override
    public void insert(AppDO app) {
        this.insert("insert", (Object)app);
    }

    @Override
    public void update(AppDO app) {
        this.update("update", (Object)app);
    }

    @Override
    public List<Long> findAllEnable() {
        return this.selectList("findAllEnable");
    }

    @Override
    public AppSimpleDto findForUpdate(Long id) {
        return (AppSimpleDto)this.selectOne("findForUpdate", id);
    }

    @Override
    public int updateSwitch(Long id, Integer appSwitch) {
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("id", id);
        map.put("appSwitch", appSwitch);
        int ret = this.update("updateSwitch", map);
        return ret;
    }

    @Override
    public List<AppSimpleDto> findAllBySpecifyAndBlack(List<Long> specifyAppIds, List<Long> blackAppIds) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        map.put("specifyAppIds", specifyAppIds);
        map.put("blackAppIds", blackAppIds);
        return this.selectList("findAllBySpecifyAndBlack", map);
    }

    @Override
    public AppSimpleDto findByAppKey(String appKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appKey", appKey);
        return (AppSimpleDto)this.selectOne("findByAppKey", map);
    }

    @Override
    public List<AppSimpleDto> findAllByDeveloper(Long developerId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("developerId", developerId);
        return this.selectList("findAllByDeveloper", map);
    }

    @Override
    public List<AppSimpleDto> findAppNameByNameLike(String appName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appName", appName);
        return this.selectList("findAppNameByNameLike", map);
    }

    @Override
    public Integer countItemAutoRecommandApp(Long itemId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("itemId", itemId);
        return (Integer)this.selectOne("countItemAutoRecommandApp", map);
    }

    @Override
    public List<Long> getAutoRecommandAppIdListByItemId(Long itemId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("itemId", itemId);
        return this.selectList("getAutoRecommandAppIdListByItemId", map);
    }

    @Override
    public List<AppSimpleDto> findAllByDeveloperIds(List<Long> developerIds) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        map.put("developerIds", developerIds);
        return this.selectList("findAllByDeveloperIds", map);
    }

    @Override
    public List<AppManageVO> findAppListByCondition(Map<String, Object> queryMap) {
        return this.selectList("findAppListByCondition", queryMap);
    }

    @Override
    public Integer findAppListCount(Map<String, Object> queryMap) {
        return (Integer)this.selectOne("findAppListCount", queryMap);
    }

    @Override
    public AppSimpleDto findFristAppByDeveloperId(Long developerId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("developerId", developerId);
        return (AppSimpleDto)this.selectOne("findFristAppByDeveloperId", map);
    }

    @Override
    public List<AppSimpleDto> findByAppIds(List<Long> appIds) {
        return this.selectList("findByAppIds", appIds);
    }

    @Override
    public List<AppDeveloperVO> selectAppDeveloper(List<Long> appIdList) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        map.put("list", appIdList);
        return this.selectList("selectAppDeveloper", map);
    }

    @Override
    public List<AppDeveloperVO> selectAllAppDeveloper(Integer start, Integer pageSize) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("start", start);
        map.put("pageSize", pageSize);
        return this.selectList("selectAllAppDeveloper", map);
    }

    @Override
    public Map<String, Object> selectOneAppDeveloper(Long appId) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("appId", appId);
        return (Map)this.selectOne("selectOneAppDeveloper", map);
    }

    @Override
    public List<Long> selectAppIdByName(String appName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("appName", appName);
        return this.selectList("selectAppIdByName", map);
    }

    @Override
    public List<Long> selectAppIdByEmail(String email) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("email", email);
        return this.selectList("selectAppIdByEmail", map);
    }

    @Override
    public List<Long> selectAppIdByEmailAndName(String email, String appName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("email", email);
        map.put("appName", appName);
        return this.selectList("selectAppIdByEmailAndName", map);
    }

    @Override
    public Integer countApp() {
        return (Integer)this.selectOne("countApp");
    }

    @Override
    public List<AppDeveloperVO> selectAppDeveloperByAppId(List<Long> appIdList) {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        map.put("list", appIdList);
        return this.selectList("selectAppDeveloperByAppId", map);
    }

    @Override
    public Integer findAppCountByDevId(Long developerId) {
        return (Integer)this.selectOne("findAppCountByDevId", developerId);
    }

    @Override
    public String findAppSecretCode(Long id) {
        return (String)this.selectOne("findAppSecretCode", id);
    }

    @Override
    public int updateAppColor(Optional<AppDO> app, Optional<String> color) {
        HashMap params = Maps.newHashMap();
        params.put("id", ((AppDO)((Object)app.get())).getId());
        params.put("color", color.get());
        return this.update("updateAppColor", params);
    }
}

