/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.developer.center.biz.remoteservice.impl;

import cn.com.duiba.developer.center.api.Instruction.AppGroupInstruction;
import cn.com.duiba.developer.center.api.domain.dto.AppBudgetDto;
import cn.com.duiba.developer.center.api.domain.dto.AppGroupDto;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.domain.dto.AppUrlDto;
import cn.com.duiba.developer.center.api.domain.paramquery.AppInfoFromParams;
import cn.com.duiba.developer.center.api.domain.paramquery.CreateAppQueryParams;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAppService;
import cn.com.duiba.developer.center.biz.bo.AppBo;
import cn.com.duiba.developer.center.biz.factory.AppGroupFactory;
import cn.com.duiba.developer.center.common.tools.ValidatorTool;
import cn.com.duiba.service.exception.BusinessException;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RemoteAppServiceImpl
implements RemoteAppService {
    @Autowired
    private AppBo appBo;
    @Autowired
    private AppGroupFactory appGroupFactory;

    public DubboResult<Long> CreateApp(CreateAppQueryParams param) {
        try {
            ValidatorTool.valid((Object)param);
            return DubboResult.successResult((Object)this.appBo.createApp(param));
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<AppSimpleDto> getSimpleApp(Long id) {
        return DubboResult.successResult((Object)this.appBo.getSimpleApp(id));
    }

    public DubboResult<AppGroupDto> getAppGroup(Long appId, AppGroupInstruction instruction) {
        return DubboResult.successResult((Object)this.appGroupFactory.createAppGroup(appId, instruction));
    }

    public DubboResult<Boolean> appInfo(AppInfoFromParams params) {
        try {
            ValidatorTool.valid((Object)params);
            this.appBo.appInfo(params);
            return DubboResult.successResult((Object)true);
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> apiConfig(AppUrlDto urlDto) {
        try {
            ValidatorTool.valid((Object)urlDto);
            this.appBo.apiConfig(urlDto);
            return DubboResult.successResult((Object)true);
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }

    public DubboResult<Boolean> budgetConfig(AppBudgetDto appBudget) {
        try {
            ValidatorTool.valid((Object)appBudget);
            this.appBo.budgetConfig(appBudget);
            return DubboResult.successResult((Object)true);
        }
        catch (BusinessException e) {
            return DubboResult.failResult((String)e.getMessage());
        }
    }
}

